function getContentBrowser(){
	var windowMediator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
	                     .getService(Components.interfaces.nsIWindowMediator);
	var topWindowOfType = windowMediator.getMostRecentWindow("navigator:browser");
	if(topWindowOfType) return topWindowOfType.document.getElementById("content");
	return null;
}

function removetabs_removeleft(usecontext) {
	var contentBrowser = getContentBrowser();
	var tabs = contentBrowser.tabContainer;
	var ctab = (usecontext ? contentBrowser.mContextTab : contentBrowser.selectedTab);
  var i;
	for(i=tabs.childNodes.length-1; tabs.childNodes[i] != ctab; i--){}
	for(i--; i>=0; i--){
		contentBrowser.removeTab(tabs.childNodes[i]);
	}
}

function removetabs_removeright(usecontext) {
	var contentBrowser = getContentBrowser();
	var tabs = contentBrowser.tabContainer;
	var ctab = (usecontext ? contentBrowser.mContextTab : contentBrowser.selectedTab);
	for(var i=tabs.childNodes.length-1; tabs.childNodes[i] != ctab; i--){
		contentBrowser.removeTab(tabs.childNodes[i]);
	}
}

function removetabs_updateEnabled() {
	var contentBrowser = getContentBrowser();
	var tabs = contentBrowser.tabContainer;
	document.getElementById("tab-removeleftmenu").setAttribute("disabled",
		(tabs.childNodes[0] == contentBrowser.mContextTab));
	document.getElementById("tab-removerightmenu").setAttribute("disabled",
		(tabs.childNodes[tabs.childNodes.length-1] == contentBrowser.mContextTab));
}

function removetabs_addMenuItem(contentBrowser, menuid) {
	var removetabsMenu = document.getElementById(menuid).cloneNode(false);
	if(!removetabsMenu){ return; }
	removetabsMenu.id = "tab-" + menuid;
	var menuParent = contentBrowser.mStrip.firstChild.nextSibling;
	var pos = 4;
	if(pos >= menuParent.childNodes.length){
	  menuParent.appendChild(removetabsMenu);
	}else{
	  menuParent.insertBefore(removetabsMenu, menuParent.childNodes[pos]);
	}
}

function removetabs_addMenuItems() {
	var contentBrowser = getContentBrowser();
	if(!contentBrowser){ return; }
	removetabs_addMenuItem(contentBrowser, "removeleftmenu");
	removetabs_addMenuItem(contentBrowser, "removerightmenu");
	contentBrowser.tabContainer.addEventListener("click", removetabs_updateEnabled, false);
}
